"use client"

import { ClientDataWrapper } from "@/components/client.data-wrapper"
import { LoadingTable } from "@/components/loading.table"
import { useGetAgencies } from "@/hooks/use-get-agencies"
import { AgenciesTable } from "./agencies.table"
import { columns } from "./agencies.table-columns"

export function AgenciesTableClient() {
  const res = useGetAgencies()

  return (
    <ClientDataWrapper
      swr={res}
      overrides={{
        loading: (
          <LoadingTable
            rowCount={10}
            columns={columns}
          />
        )
      }}
      content={(data) => (
        <AgenciesTable data={data} />
      )}
    />
  )
}
